package com.izenpe.zain.cliente.wss;

import com.izenpe.zain.client.ZainConfig;
import com.izenpe.zain.cliente.util.Constantes;
import com.izenpe.zain.cliente.util.Propiedades;
import com.izenpe.zain.cliente.util.ZainUtil;
import com.safelayer.trustedx.client.smartwrapper.Constants;
import com.safelayer.trustedx.client.smartwrapper.SmartEncryptRequest;
import com.safelayer.trustedx.client.smartwrapper.SmartEncryptResponse;

public class WssEncryption {
	
	private static final String fileName = "WS-Security.xml";
	
    public static void main(String args[]) throws Exception {   	    	
    	
    	try{
        	// Asignacin de la configuracin de forma programtica
    		ZainConfig.setCurrent(Propiedades.ZAIN_CONFIG);
        	
    		/*
			 * Se crea la peticin a travs de la URL definida en ZAIN_ENDPOINT.
			 */
        	SmartEncryptRequest eReq =  new SmartEncryptRequest(Propiedades.ZAIN_ENDPOINT);    	
        	
        	/*
			 * Se selecciona el tipo de cifrado WSS
			 */
        	eReq.setProfile(Constants.Profile.WSS);
        	
        	/*
			 * Datos a cifrar
			 */
        	eReq.setInputXmlData(new String(ZainUtil.readBinaryFile("data/input/" + fileName)));
        	eReq.setXmlAddEncryptedKeyInfo(Constants.EncryptedKeyInfo.X509CERTIFICATE);          	
        	
        	/*
			 * Escoge el recipient o destinatario para ese cifrado, seleccionndolo a partir de su nombre distintivo
			 */
        	eReq.setKeySubjectName(Propiedades.RECIPIENT_DN);    	    	
        	
        	SmartEncryptResponse eRes = eReq.send();
        		      
        	if (Constantes.RMAJOR_SUCCESS.equals(eRes.getResultMajor())
    	      && eRes.getResultMinor() == null) {
        		System.out.println("Encryption OK");
        		String encrypted = eRes.getEnvelopeXmlData();
    			byte[] dataByte = encrypted.getBytes();
    			String destFilename = "data/output/WSSEncrypted.xml";
    			ZainUtil.writeBinaryFile(destFilename, dataByte);
    	    } else {
    	        throw new Exception("Error encrypting: " + eRes.getResultMessage());
    	    }   
    	}catch (Exception e) {
    		System.out.println("Error en la encriptacin de un WSS");
			e.printStackTrace();
		}
    } 
}
